
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Cereal_Production")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Nutritional_Cereal")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Kids_Cereal")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Sugary_Cereal")

# Set objective function
m.setObjective(1*x1 + 1.5*x2 + 2*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 1.5*x2 + 2*x3 <= 500, "Oat_Constraint")
m.addConstr(1*x1 + 1.5*x2 + 4*x3 <= 700, "Sugar_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal:.2f}")
    print(f"Nutritional Cereal: {x1.x:.2f} boxes")
    print(f"Kids' Cereal: {x2.x:.2f} boxes")
    print(f"Sugary Cereal: {x3.x:.2f} boxes")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

