
from gurobipy import *

# Create a new model
m = Model("Cereal_Production")

# Define the decision variables
x1 = m.addVar(name="Nutritional_Cereal", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Kids_Cereal", vtype=GRB.CONTINUOUS, lb=0)
x3 = m.addVar(name="Sugary_Cereal", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(x1 + 1.5*x2 + 2*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 1.5*x2 + 2*x3 <= 500, name="Oat_Constraint")
m.addConstr(x1 + 1.5*x2 + 4*x3 <= 700, name="Sugar_Constraint")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective Value: {m.objVal}")
