
import gurobi

def solve_cereal_production():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    N = model.addVar(name="Nutritional", lb=0, ub=gurobi.GRB.INFINITY)
    K = model.addVar(name="Kids", lb=0, ub=gurobi.GRB.INFINITY)
    S = model.addVar(name="Sugary", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Maximize revenue
    model.setObjective(1*N + 1.5*K + 2*S, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*N + 1.5*K + 2*S <= 500, name="Oat_Constraint")
    model.addConstr(1*N + 1.5*K + 4*S <= 700, name="Sugar_Constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Nutritional Cereal: {N.varValue}")
        print(f"Kids' Cereal: {K.varValue}")
        print(f"Sugary Cereal: {S.varValue}")
        print(f"Max Revenue: {model.objVal}")
    else:
        print("The model is infeasible")

solve_cereal_production()
