
import gurobipy as gp

# Create a new model
m = gp.Model("Lighting_Problem")

# Create decision variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="desk_lamps") # Integer number of desk lamps
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chandeliers") # Integer number of chandeliers

# Set objective function
m.setObjective(200*x + 500*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 60*y <= 1500, "manufacturing_time")
m.addConstr(x + 15*y <= 300, "light_bulbs")
m.addConstr(x >= 40, "min_desk_lamps")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Desk Lamps: {x.x}")
    print(f"Number of Chandeliers: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

