
from gurobipy import *

# Create a new model
m = Model("Lighting_Company_Profit")

# Define variables
x = m.addVar(lb=40, vtype=GRB.INTEGER, name="desk_lamps")  # Number of desk lamps
y = m.addVar(vtype=GRB.INTEGER, name="chandeliers")  # Number of chandeliers

# Set the objective function: Maximize profit
m.setObjective(200*x + 500*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 60*y <= 1500, "manufacturing_time")
m.addConstr(x + 15*y <= 300, "light_bulbs")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {int(x.x)}, {y.varName} = {int(y.x)}")
    print(f"Maximum Profit: ${200*int(x.x) + 500*int(y.x)}")
else:
    print("No optimal solution found.")
