
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=40, name="desk_lamps")  # At least 40 desk lamps
    y = model.addVar(lb=0, name="chandeliers")

    # Objective function: Maximize profit
    model.setObjective(200 * x + 500 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20 * x + 60 * y <= 1500, name="manufacturing_time")
    model.addConstr(x + 15 * y <= 300, name="light_bulbs")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: desk lamps = {x.varValue}, chandeliers = {y.varValue}")
        print(f"Max profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
