
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create decision variables
x1 = m.addVar(lb=0, name="video_game")
x2 = m.addVar(lb=0, name="camera")
x3 = m.addVar(lb=0, name="cell_phone")
x4 = m.addVar(lb=0, name="laptop")

# Set objective function
m.setObjective(0.07*x1 + 0.03*x2 + 0.09*x3 + 0.07*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 + x4 <= 300000, "total_investment")
m.addConstr(x4 <= x1, "laptop_vs_video_game")
m.addConstr(x2 <= x3, "camera_vs_cell_phone")
m.addConstr(x4 <= 0.15 * 300000, "laptop_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Video Game Investment: ${x1.x:.2f}")
    print(f"Camera Investment: ${x2.x:.2f}")
    print(f"Cell Phone Investment: ${x3.x:.2f}")
    print(f"Laptop Investment: ${x4.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

