
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="Video_Game_Company")
x2 = m.addVar(lb=0, name="Camera_Company")
x3 = m.addVar(lb=0, name="Cell_Phone_Company")
x4 = m.addVar(lb=0, name="Laptop_Company")

# Objective function
m.setObjective(0.07*x1 + 0.03*x2 + 0.09*x3 + 0.07*x4, GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 + x3 + x4 == 300000, name="Total_Investment")
m.addConstr(x4 <= x1, name="Laptop_vs_Video_Game")
m.addConstr(x2 <= x3, name="Camera_vs_Cell_Phone")
m.addConstr(x4 <= 45000, name="Max_Laptop_Investment")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Total Return: {m.objVal}")
