
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="video_game_company")
    x2 = model.addVar(lb=0, name="camera_company")
    x3 = model.addVar(lb=0, name="cell_phone_company")
    x4 = model.addVar(lb=0, name="laptop_company")

    # Objective function: Maximize the return on investment
    model.setObjective(0.07*x1 + 0.03*x2 + 0.09*x3 + 0.07*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x4 <= x1, name="laptop_vs_video_game")
    model.addConstr(x2 <= x3, name="camera_vs_cell_phone")
    model.addConstr(x4 <= 0.15 * 300000, name="laptop_limit")
    model.addConstr(x1 + x2 + x3 + x4 <= 300000, name="total_investment")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Video Game Company: ${x1.varValue:.2f}")
        print(f"Camera Company: ${x2.varValue:.2f}")
        print(f"Cell Phone Company: ${x3.varValue:.2f}")
        print(f"Laptop Company: ${x4.varValue:.2f}")
        print(f"Max Return: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
