
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create decision variables
x = m.addVar(lb=0, name="film_investment")
y = m.addVar(lb=0, name="healthcare_investment")

# Set objective function
m.setObjective(0.08 * x + 0.10 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200000, "total_investment")
m.addConstr(x >= 0.25 * 200000, "min_film_investment")
m.addConstr(y <= 0.60 * 200000, "max_healthcare_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in Film Industry: ${x.x}")
    print(f"Optimal investment in Healthcare Industry: ${y.x}")
    print(f"Maximum return: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

