
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the decision variables
x_f = m.addVar(name="film_investment", lb=0)
x_h = m.addVar(name="healthcare_investment", lb=0)

# Objective function: Maximize return on investment
m.setObjective(0.08*x_f + 0.10*x_h, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_f + x_h == 200000)  # Total investment constraint
m.addConstr(x_f >= 50000)         # Minimum investment in film industry
m.addConstr(x_h <= 120000)        # Maximum investment in healthcare industry

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal film investment: ${x_f.x:.2f}")
    print(f"Optimal healthcare investment: ${x_h.x:.2f}")
    print(f"Maximum return on investment: ${m.ObjVal:.2f}")
else:
    print("Model is infeasible")
