
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="film_investment", lb=0)
    y = model.addVar(name="healthcare_investment", lb=0)

    # Objective function: Maximize 0.08x + 0.10y
    model.setObjective(0.08 * x + 0.10 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y == 200000, name="total_investment")
    model.addConstr(x >= 0.25 * 200000, name="min_film_investment")
    model.addConstr(y <= 0.60 * 200000, name="max_healthcare_investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal film investment: ${x.varValue}")
        print(f"Optimal healthcare investment: ${y.varValue}")
        print(f"Max return: ${0.08 * x.varValue + 0.10 * y.varValue}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
