
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("chocolate_production")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="chocolate_bars")
y = m.addVar(vtype=GRB.INTEGER, name="chocolate_wafers")

# Set objective function
m.setObjective(2*x + 3*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x <= 80, "bar_production_limit")
m.addConstr(y <= 100, "wafer_production_limit")
m.addConstr(x + y <= 125, "packaging_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Chocolate Bars: {x.x}")
    print(f"Number of Chocolate Wafers: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

