
from gurobipy import *

# Create a model
m = Model("Chocolate_Production")

# Define decision variables
x = m.addVar(lb=0, name="chocolate_bars")  # Number of chocolate bars
y = m.addVar(lb=0, name="chocolate_wafers")  # Number of chocolate wafers

# Define constraints
m.addConstr(x <= 80, name="max_chocolate_bars")
m.addConstr(y <= 100, name="max_chocolate_wafers")
m.addConstr(x + y <= 125, name="max_packaging_capacity")

# Define objective function
m.setObjective(2*x + 3*y, GRB.MAXIMIZE)

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate Bars: {x.x}")
    print(f"Chocolate Wafers: {y.x}")
    print(f"Total Profit: ${2*x.x + 3*y.x}")
else:
    print("No optimal solution found")
