
import gurobi

def solve_chocolate_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, ub=80, name="ChocolateBars")
    y = model.addVar(lb=0, ub=100, name="ChocolateWafers")

    # Objective function: Maximize 2x + 3y
    model.setObjective(2 * x + 3 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x <= 80, name="BarProductionLimit")
    model.addConstr(y <= 100, name="WaferProductionLimit")
    model.addConstr(x + y <= 125, name="PackagingLimit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production level for chocolate bars: {x.varValue}")
        print(f"Optimal production level for chocolate wafers: {y.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_chocolate_production()
