
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Flower_Profit")

# Create variables
x = m.addVar(lb=0, name="lavender") # Acres of lavender
y = m.addVar(lb=0, name="tulips")   # Acres of tulips

# Set objective function
m.setObjective(250*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50, "land_availability")
m.addConstr(x >= 5, "min_lavender")
m.addConstr(y >= 8, "min_tulips")
m.addConstr(x <= 2*y, "lavender_tulip_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of lavender")
    print(f"Plant {y.x:.2f} acres of tulips")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

