
from gurobipy import *

# Create a new model
m = Model("Gardener_Optimization")

# Define decision variables
L = m.addVar(name="lavender_acres", lb=0)  # Acres for lavender, lower bound 0
T = m.addVar(name="tulip_acres", lb=0)    # Acres for tulips, lower bound 0

# Objective function: Maximize profit
m.setObjective(250*L + 200*T, GRB.MAXIMIZE)

# Constraints
m.addConstr(L + T <= 50, name="total_acres")     # Total acres constraint
m.addConstr(L >= 5, name="min_lavender_acres")    # Minimum lavender acres
m.addConstr(T >= 8, name="min_tulip_acres")       # Minimum tulip acres
m.addConstr(L <= 2*T, name="lavender_to_tulip_ratio")  # Lavender to tulip ratio

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lavender acres: {L.x}")
    print(f"Tulip acres: {T.x}")
    print(f"Total profit: ${250*L.x + 200*T.x:.2f}")
else:
    print("No optimal solution found")
