
import gurobipy as gp

# Create a new model
model = gp.Model("Lavender_Tulips_Optimization")

# Define the decision variables
L = model.addVar(lb=5, name="Lavender_Acres")  # At least 5 acres of lavender
T = model.addVar(lb=8, name="Tulips_Acres")    # At least 8 acres of tulips

# Objective function: Maximize profit
model.setObjective(250*L + 200*T, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(L + T <= 50, name="Total_Acres")  # Total acres constraint
model.addConstr(L <= 2*T, name="Lavender_vs_Tulips")  # Lavender vs. tulips constraint

# Solve the model
model.solve()

# Output the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution:")
    print(f"Lavender Acres: {L.varValue}")
    print(f"Tulips Acres: {T.varValue}")
    print(f"Max Profit: ${250*L.varValue + 200*T.varValue}")
else:
    print("No optimal solution found.")
