
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("seat_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="heated_seats")
y = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(20*x + 15*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "total_seats")
m.addConstr(x >= 15, "min_heated")
m.addConstr(y >= 3*x, "regular_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of heated seats: {x.x}")
    print(f"Number of regular seats: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

