
from gurobipy import *

# Create a model
m = Model("Train_Seat_Optimization")

# Define the decision variables
H = m.addVar(lb=0, vtype=GRB.INTEGER, name="Heated_Sears")
R = m.addVar(lb=0, vtype=GRB.INTEGER, name="Regular_Sears")

# Set the objective function: Maximize profit
m.setObjective(20*H + 15*R, GRB.MAXIMIZE)

# Add constraints
m.addConstr(H + R <= 100, "Total_Seats")
m.addConstr(H >= 15, "Minimum_Heated_Seats")
m.addConstr(R >= 3*H, "Regular_vs_Heated")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Heated Seats: {H.x}")
    print(f"Regular Seats: {R.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")

