
import gurobi

def solve_seat_allocation():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    H = model.addVar(name="heated_seats", lb=0, ub=100, vtype=gurobi.GRB.INTEGER)
    R = model.addVar(name="regular_seats", lb=0, ub=100, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(20 * H + 15 * R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(H + R <= 100, name="total_seats")
    model.addConstr(H >= 15, name="min_heated_seats")
    model.addConstr(R >= 3 * H, name="regular_to_heated_ratio")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: {model.objVal}")
        print(f"Heated seats: {H.varValue}")
        print(f"Regular seats: {R.varValue}")
    else:
        print("The model is infeasible")

solve_seat_allocation()
