
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pharmacy_optimization")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="x") # pills
y = m.addVar(vtype=GRB.CONTINUOUS, name="y") # cream

# Set objective
m.setObjective(50*x + 60*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 15*y <= 4000, "weighing_time")
m.addConstr(10*x + 15*y <= 3000, "packaging_time")
m.addConstr(x >= 0, "x_non_negative")
m.addConstr(y >= 0, "y_non_negative")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of pill bottles: {x.x}")
    print(f"Number of cream bottles: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

