
from gurobipy import *

# Create a new model
m = Model("Pharmacy_Optimization")

# Define variables
x = m.addVar(name="bottles_of_pills", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="bottles_of_cream", vtype=GRB.CONTINUOUS, lb=0)

# Define the objective function (maximize profit)
m.setObjective(50*x + 60*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 15*y <= 4000, name="weighing_time_constraint")
m.addConstr(10*x + 15*y <= 3000, name="packaging_time_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bottles of pills: {x.x}")
    print(f"Number of bottles of cream: {y.x}")
    print(f"Maximum profit: ${50*x.x + 60*y.x:.2f}")
else:
    print("No optimal solution found")

