
from gurobi import *

def solve_pharmacy_problem():
    model = Model()

    x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bottles_of_pills")
    y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bottles_of_cream")

    model.setObjective(50*x + 60*y, GRB.MAXIMIZE)

    model.addConstr(20*x + 15*y <= 4000, name="weighing_time")
    model.addConstr(10*x + 15*y <= 3000, name="packaging_time")

    model.optimize()

    if model.status == GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_pharmacy_problem()
