
import gurobipy as gp

# Create a new model
model = gp.Model("CaviarProduction")

# Create variables
e = model.addVar(lb=0, name="Eastern_Days")
w = model.addVar(lb=0, name="Western_Days")

# Set objective function
model.setObjective(1000*e + 2000*w, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(5*e + 2*w >= 25, "Cheap_Caviar")
model.addConstr(7*e + 6*w >= 35, "Regular_Caviar")
model.addConstr(1*e + 4*w >= 15, "Expensive_Caviar")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Eastern Location Days: {e.x}")
    print(f"Western Location Days: {w.x}")
    print(f"Total Cost: ${model.objVal}")
else:
    print("Infeasible or unbounded")

