
from gurobipy import *

# Create a model
m = Model("Caviar_Production")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Eastern_Location_Days")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Western_Location_Days")

# Objective function: Minimize total weekly cost
m.setObjective(1000*x + 2000*y, GRB.MINIMIZE)

# Constraints
m.addConstr(5*x + 2*y >= 25, name="Cheap_Caviar_Demand")
m.addConstr(7*x + 6*y >= 35, name="Regular_Caviar_Demand")
m.addConstr(x + 4*y >= 15, name="Expensive_Caviar_Demand")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Eastern location should operate for {x.x} days.")
    print(f"Western location should operate for {y.x} days.")
    print(f"Total weekly cost: ${m.objVal}")
else:
    print("No optimal solution found.")

