
import gurobi

def solve_caviar_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x_e = model.addVar(name="Eastern_Days", lb=0, vtype=gurobi.GRB.INTEGER)
    x_w = model.addVar(name="Western_Days", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize operating costs
    model.setObjective(1000 * x_e + 2000 * x_w, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * x_e + 2 * x_w >= 25, name="Cheap_Caviar_Constraint")
    model.addConstr(7 * x_e + 6 * x_w >= 35, name="Regular_Caviar_Constraint")
    model.addConstr(x_e + 4 * x_w >= 15, name="Expensive_Caviar_Constraint")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Eastern location operates {x_e.varValue} days, Western location operates {x_w.varValue} days")
        print(f"Minimum Cost: ${model.objVal}")
    else:
        print("The problem is infeasible")

solve_caviar_problem()
