
import gurobipy as gp

# Create a new model
model = gp.Model("CandyComboOptimization")

# Create decision variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # Combo 1 packages
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # Combo 2 packages


# Set the objective function
model.setObjective(4*x1 + 4.5*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(25*x1 + 12*x2 <= 1200, "GummyBears")
model.addConstr(20*x1 + 21*x2 <= 1400, "GummyWorms")
model.addConstr(15*x1 + 24*x2 <= 900, "SourCandies")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Maximum Profit: ${model.objVal:.2f}")
    print(f"Number of Combo 1 packages: {x1.x:.2f}")
    print(f"Number of Combo 2 packages: {x2.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

