
from gurobipy import *

# Create a new model
m = Model("Grocery_Store_Problem")

# Define the decision variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Combo_1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Combo_2")

# Set the objective function
m.setObjective(4*x1 + 4.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x1 + 12*x2 <= 1200, "Gummy_Bears_Constraint")
m.addConstr(20*x1 + 21*x2 <= 1400, "Gummy_Worms_Constraint")
m.addConstr(15*x1 + 24*x2 <= 900, "Sour_Candies_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Combo 1: {x1.x}")
    print(f"Number of Combo 2: {x2.x}")
    print(f"Maximum Profit: ${4*x1.x + 4.5*x2.x:.2f}")
else:
    print("No optimal solution found.")
