
import gurobipy as gp

# Create a new model
m = gp.Model("Gummy_Candy_Combo_Optimization")

# Define decision variables
x1 = m.addVar(name="Combo_1", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="Combo_2", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
m.setObjective(4 * x1 + 4.5 * x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(25 * x1 + 12 * x2 <= 1200, name="Gummy_Bears_Constraint")
m.addConstr(20 * x1 + 21 * x2 <= 1400, name="Gummy_Worms_Constraint")
m.addConstr(15 * x1 + 24 * x2 <= 900, name="Sour_Candies_Constraint")

# Solve the model
m.solve()

# Output the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Combo 1 = {x1.varValue}, Combo 2 = {x2.varValue}")
    print(f"Maximum Profit: ${m.objVal:.2f}")
else:
    print("The model is infeasible.")
