
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("PaperProduction")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="lined_paper")
y = model.addVar(vtype=GRB.CONTINUOUS, name="graph_paper")

# Set objective function
model.setObjective(11 * x + 13 * y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * x + 2 * y <= 3500, "cutting_constraint")
model.addConstr(6 * x + 10 * y <= 3500, "printing_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Lined paper: {x.x:.2f} reams")
    print(f"Graph paper: {y.x:.2f} reams")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

