
from gurobipy import *

# Create a model
m = Model("PaperProduction")

# Define decision variables
L = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="LinedPaper")
G = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="GraphPaper")

# Objective function: Maximize profit
m.setObjective(11*L + 13*G, GRB.MAXIMIZE)

# Constraint for cutting machine
m.addConstr(2*L + 2*G <= 3500, "CuttingMachine")

# Constraint for line-printing machine
m.addConstr(6*L + 10*G <= 3500, "LinePrintingMachine")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {L.x:.2f} reams of lined paper and {G.x:.2f} reams of graph paper.")
else:
    print("No optimal solution found.")
