
import gurobi

def solve_paper_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="Lined Paper")
    y = model.addVar(lb=0, name="Graph Paper")

    # Define the objective function
    model.setObjective(11*x + 13*y, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(2*x + 2*y <= 3500, name="Cutting Machine")
    model.addConstr(6*x + 10*y <= 3500, name="Line-Printing Machine")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Lined Paper = {x.varValue}, Graph Paper = {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

# Run the function
solve_paper_company_problem()
