
import gurobipy as gp

# Create a new model
m = gp.Model("Chair Production")

# Create decision variables
x = m.addVar(lb=0, name="desk_chairs")  # Desk chairs
y = m.addVar(lb=0, name="garden_chairs") # Garden chairs

# Set objective function
m.setObjective(100*x + 150*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 250, "demand")
m.addConstr(200*x + 300*y <= 35000, "budget")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of desk chairs: {x.x:.0f}")
    print(f"Number of garden chairs: {y.x:.0f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

