
from gurobipy import *

# Create a new model
m = Model("Nova_Furniture_Optimization")

# Define the decision variables
x_d = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="desk_chairs")
x_g = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="garden_chairs")

# Set the objective function: Maximize profit
m.setObjective(100*x_d + 150*x_g, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_d + x_g <= 250, "Total_Demand_Constraint")
m.addConstr(200*x_d + 300*x_g <= 35000, "Manufacturing_Budget_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Desk Chairs: {x_d.x}")
    print(f"Garden Chairs: {x_g.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
