
import gurobi

def solve_nova_furniture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    D = model.addVar(name="Desk_Chair", lb=0, ub=None, obj=100)
    G = model.addVar(name="Garden_Chair", lb=0, ub=None, obj=150)

    # Add constraints
    model.addConstr(D + G <= 250, name="Demand_Constraint")
    model.addConstr(200*D + 300*G <= 35000, name="Budget_Constraint")

    # Set the model to maximize the objective function
    model.setObjective(D.obj * 1 + G.obj * 1, gurobi.GRB.MAXIMIZE)

    # However, the right approach is directly using the defined variables and their objectives,
    # so we actually do not need to explicitly set it as the obj attribute of the variables already defines it.

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Desk Chairs: {D.x}")
        print(f"Garden Chairs: {G.x}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_nova_furniture_problem()
