
import gurobipy as gp

# Create a new model
m = gp.Model("video_game_profit")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="consoles")
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="discs")

# Set objective
m.setObjective(200*x + 30*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(300*x + 30*y <= 30000, "budget")
m.addConstr(x >= 20, "min_consoles")
m.addConstr(x <= 50, "max_consoles")
m.addConstr(y <= 5*x, "disc_limit")

# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of consoles to sell: {x.x}")
    print(f"Number of discs to sell: {y.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

