
from gurobipy import *

# Create a new model
m = Model("Video_Game_Store")

# Define variables
consoles = m.addVar(lb=20, ub=50, vtype=GRB.INTEGER, name="consoles")
discs = m.addVar(vtype=GRB.INTEGER, name="discs")

# Objective function: Maximize profit
m.setObjective(200*consoles + 30*discs, GRB.MAXIMIZE)

# Constraints
m.addConstr(300*consoles + 30*discs <= 30000, "Budget_Constraint")
m.addConstr(discs <= 5*consoles, "Discs_vs_Consoles")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Consoles to sell: {consoles.x}")
    print(f"Discs to sell: {discs.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
