
import gurobi

def maximize_profit():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=20, ub=50, name="consoles")  # Number of consoles
    y = model.addVar(lb=0, name="discs")  # Number of discs

    # Objective function: Maximize profit
    model.setObjective(200 * x + 30 * y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(300 * x + 30 * y <= 30000, name="budget_constraint")

    # Disc sales constraint
    model.addConstr(y <= 5 * x, name="disc_sales_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Consoles = {x.varValue}, Discs = {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

maximize_profit()
