
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("MeatDiet")

# Create variables
x = m.addVar(lb=0, name="elk")
y = m.addVar(lb=0, name="bison")

# Set objective function
m.setObjective(6*x + 7*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x + 4*y >= 30, "IronRequirement")
m.addConstr(3*x + 4*y >= 40, "ZincRequirement")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: {m.objVal}")
    print(f"Elk servings: {x.x}")
    print(f"Bison servings: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

