
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Define the variables
elk_servings = m.addVar(vtype=GRB.CONTINUOUS, name="Elk_Servings", lb=0)
bison_servings = m.addVar(vtype=GRB.CONTINUOUS, name="Bison_Servings", lb=0)

# Set the objective function: minimize cost
m.setObjective(6*elk_servings + 7*bison_servings, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*elk_servings + 4*bison_servings >= 30, name="Iron_Requirement")
m.addConstr(3*elk_servings + 4*bison_servings >= 40, name="Zinc_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Elk servings: {elk_servings.x}")
    print(f"Bison servings: {bison_servings.x}")
    print(f"Total cost: ${6*elk_servings.x + 7*bison_servings.x:.2f}")
else:
    print("No optimal solution found. The problem might be infeasible.")
