
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(lb=0, name="elk_meat")
    y = model.addVar(lb=0, name="bison_meat")

    # Define the objective function
    model.setObjective(6*x + 7*y, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x + 4*y >= 30, name="iron_requirement")
    model.addConstr(3*x + 4*y >= 40, name="zinc_requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Elk meat servings: {x.varValue}")
        print(f"Bison meat servings: {y.varValue}")
        print(f"Total cost: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model status is not optimal or infeasible.")

# Run the function
solve_optimization_problem()
