
import gurobipy as gp

# Create a new model
model = gp.Model("ViolinProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="modern_violins")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="baroque_violins")

# Set objective function
model.setObjective(150 * x + 200 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * x + 4 * y <= 150, "woodworking_constraint")
model.addConstr(3.5 * x + 5 * y <= 200, "assembling_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Modern Violins: {x.x}")
    print(f"Baroque Violins: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

