
from gurobipy import *

# Create a new model
m = Model("Violin_Factory")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="modern_violins")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="baroque_violins")

# Set the objective function: Maximize profits
m.setObjective(150*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 4*y <= 150, "woodworking_time")
m.addConstr(3.5*x + 5*y <= 200, "assembling_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Modern violins: {x.x}")
    print(f"Baroque violins: {y.x}")
    print(f"Total profit: ${150*x.x + 200*y.x:.2f}")
else:
    print("No optimal solution found")
