
import gurobi

def solve_violin_factory_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(lb=0, name="modern_violins")  # Number of modern violins
    y = model.addVar(lb=0, name="baroque_violins")  # Number of baroque violins

    # Objective function: Maximize profit
    model.setObjective(150*x + 200*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x + 4*y <= 150, name="woodworking_time")  # Woodworking time constraint
    model.addConstr(3.5*x + 5*y <= 200, name="assembling_time")  # Assembling time constraint

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Produce {x.varValue} modern violins and {y.varValue} baroque violins.")
        print(f"Maximum profit: ${150*x.varValue + 200*y.varValue:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
solve_violin_factory_problem()
