
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Flooring_Optimization")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="hardwood")  # Hardwood flooring
y = m.addVar(vtype=GRB.CONTINUOUS, name="carpet")  # Carpet

# Set objective function
m.setObjective(400*x + 650*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x + 0.5*y <= 200, "Cutting_Time")
m.addConstr(3*x + 4*y <= 400, "Installation_Time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Hardwood Flooring Installations: {x.x}")
    print(f"Carpet Installations: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

