
from gurobipy import *

# Create a new model
m = Model("Flooring_Optimization")

# Define the decision variables
H = m.addVar(vtype=GRB.CONTINUOUS, name="Hardwood_Flooring", lb=0)
C = m.addVar(vtype=GRB.CONTINUOUS, name="Carpet", lb=0)

# Set the objective function to maximize profit
m.setObjective(400*H + 650*C, GRB.MAXIMIZE)

# Add constraints for cutting and installation time
m.addConstr(H + 0.5*C <= 200, "Cutting_Time")
m.addConstr(3*H + 4*C <= 400, "Installation_Time")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hardwood Flooring: {H.x}")
    print(f"Carpet: {C.x}")
    print(f"Maximum Profit: ${400*H.x + 650*C.x:.2f}")
else:
    print("No optimal solution found.")
