
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
H = m.addVar(lb=0, name="Hardwood_Flooring")
C = m.addVar(lb=0, name="Carpet")

# Define the objective function
m.setObjective(400 * H + 650 * C, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(1 * H + 0.5 * C <= 200, name="Cutting_Constraint")
m.addConstr(3 * H + 4 * C <= 400, name="Installation_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hardwood Flooring: {H.varValue}")
    print(f"Carpet: {C.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
