
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("wedding_cake")

# Create variables
x = m.addVar(lb=0, name="vanilla")
y = m.addVar(lb=0, name="chocolate")

# Set objective
m.setObjective(10*x + 15*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.03*x + 0.02*y >= 0.3, "leavening")
m.addConstr(0.55*x + 0.43*y >= 10, "flour")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Vanilla cake mix: {x.x} kg")
    print(f"Chocolate cake mix: {y.x} kg")
    print(f"Minimum cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

