
from gurobipy import *

# Create a new model
m = Model("Wedding_Cake")

# Define the decision variables
V = m.addVar(name="Vanilla", vtype=GRB.CONTINUOUS, lb=0)
C = m.addVar(name="Chocolate", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(10*V + 15*C, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.03*V + 0.02*C >= 0.3, name="Leavening_Agent")
m.addConstr(0.55*V + 0.43*C >= 10, name="Flour")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Vanilla cake mix to buy: {V.x} kg")
    print(f"Chocolate cake mix to buy: {C.x} kg")
    print(f"Total cost: ${10*V.x + 15*C.x}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
